unit PZDMain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, PZBpanel, StdCtrls, PZShaded, PZSpButt,
  PZLabel, PZDLabel, PZDShade, PZDBPane, PZDSpBut, PZDLView, PZDTView;

type
  TMainForm = class(TForm)
    MainPanel: TPanel;
    Panel2: TPanel;
    PZLabelSB: TPZSpeedButton;
    PZBitmapPabelSB: TPZSpeedButton;
    PZListViewSB: TPZSpeedButton;
    PZTreeViewSB: TPZSpeedButton;
    PZSpeedButtonSB: TPZSpeedButton;
    PZShadedSB: TPZSpeedButton;
    PZBitmapPanel1: TPZBitmapPanel;
    procedure FormCreate(Sender: TObject);
    procedure PZLabelSBClick(Sender: TObject);
    procedure PZShadedSBClick(Sender: TObject);
    procedure PZBitmapPabelSBClick(Sender: TObject);
    procedure PZSpeedButtonSBClick(Sender: TObject);
    procedure PZListViewSBClick(Sender: TObject);
    procedure PZTreeViewSBClick(Sender: TObject);
  private
    { Private declarations }
    procedure WMPaletteChanged(var Message: TMessage); message WM_PALETTECHANGED;
    procedure WMQueryNewPalette(var Message: TMessage); message WM_QUERYNEWPALETTE;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}
{$R PZDBmps}

procedure TMainForm.FormCreate(Sender: TObject);

Const
  InitSize =0.75;

begin
  Width:=Round(Screen.Width*InitSize);
  Height:=Round(Screen.Height*InitSize);
  Left:=(Screen.Width Div 2)-(Width Div 2);
  Top:=(Screen.Height Div 2)-(Height Div 2);
  WindowState:=wsMaximized;
end;

procedure TMainForm.PZLabelSBClick(Sender: TObject);

Var
  PZLabelForm :TPZLabelForm;

begin
  PZLabelForm:=TPZLabelForm.Create(Self);
end;

procedure TMainForm.PZShadedSBClick(Sender: TObject);

Var
  PZShadedForm :TPZShadedForm;

begin
  PZShadedForm:=TPZShadedForm.Create(Self);
end;

procedure TMainForm.PZBitmapPabelSBClick(Sender: TObject);

Var
  PZBitmapPanelForm :TPZBitmapPanelForm;

begin
  PZBitmapPanelForm:=TPZBitmapPanelForm.Create(Self);
end;

procedure TMainForm.PZSpeedButtonSBClick(Sender: TObject);

Var
  PZSpeedButtonForm :TPZSpeedButtonForm;

begin
  PZSpeedButtonForm:=TPZSpeedButtonForm.Create(Self);
end;

procedure TMainForm.PZListViewSBClick(Sender: TObject);

Var
  PZListViewForm :TPZListViewForm;

begin
  PZListViewForm:=TPZListViewForm.Create(Self);
end;

procedure TMainForm.PZTreeViewSBClick(Sender: TObject);

Var
  PZTreeViewForm :TPZTreeViewForm;

begin
  PZTreeViewForm:=TPZTreeViewForm.Create(Self);
End;

procedure TMainForm.WMPaletteChanged(var Message: TMessage);

Var
  c :Integer;

Begin
  inherited;
  For c:=0 To MDIChildCount-1 Do
    With MDIChildren[c] Do
      SendMessage(Handle,WM_PaletteChanged,Message.WParam,0);
End;

procedure TMainForm.WMQueryNewPalette(var Message: TMessage);

Var
  c :Integer;

Begin
  inherited;
  For c:=0 To MDIChildCount-1 Do
    With MDIChildren[c] Do
      SendMessage(Handle,WM_QueryNewPalette,0,0);
End;

end.
